<?php

namespace App\Http\Controllers;

use App\Http\Requests\UserRequest;
use App\Models\Role;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use function PHPUnit\Framework\isInt;
use Illuminate\Http\RedirectResponse;

use Illuminate\Auth\Events\Registered;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;

class UserController extends Controller
{

    /**
     * Activate the user
     */
    public function activate(Request $request){
        $user = auth()->user();
        if($user->role_id==1){
            $dados = $request->all();
           // dd($dados['valor']);
            $user = User::findORFail($dados['valor']);
            $user->update(
                [
                    'estado_id'=>'1',
                ]
            );
            return redirect()->back();
            
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
    }

    /**
     * DeActivate the user
     */
    public function deactivate(Request $request){
        $dados = $request->all();
        $user = auth()->user();
        if($user->role_id==1){
           // dd($dados['valor']);
           
            $user = User::findORFail($dados['valor']);
            
            $user->update(
                [
                    'estado_id'=>'2',
                ]
            );
            return redirect()->back();
            
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
    }


    /**
     * Display a listing of the resource.
     */
    public function index(){
        $user =  auth()->user();
        $users = DB::table('users')
            ->join('entidades', 'users.entidade_id', '=', 'entidades.id')
            ->join('roles', 'users.role_id', '=', 'roles.id')
            ->join('estados', 'users.estado_id', '=', 'estados.id')
            ->select('users.*','users.id as user_id', 'users.email as userEmail', 'entidades.*', 'roles.*','estados.*')
            ->where("users.entidade_id",$user->entidade_id)
            ->paginate(10);
          //  dd($users);
            return view('utilizador.index',compact('users','user'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $user = auth()->user();
        if($user->role_id==1){
            $roles = Role::all();
            return view('utilizador.create',compact('roles'));
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
    }

    /**
     * Handle an incoming registration request.
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request): RedirectResponse
    {
        $entidade = null;
        $user = auth()->user();
        if($user->role_id==1)
        {
            $entidade = $user->entidade_id;

            $request->validate([
                'role' => ['required', 'integer'],
                'name' => ['required', 'string', 'max:255'],
                'email' => ['required', 'string', 'lowercase', 'email', 'max:255', 'unique:'.User::class],
                'password' => ['required', 'confirmed', Rules\Password::defaults()],
            ]);

            $roles = Role::findOrFail($request->role);
            $user = User::create([
                'name' => $request->name,
                'email' => $request->email,
                'entidade_id' => $entidade,
                'role_id' => $request->role,
                'estado_id' => 1,
                'password' => Hash::make($request->password)
            ]);
            
           // return $this->create();
            return redirect(route('dashboard', absolute: false));
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
        
       //return redirect(route('dashboard', absolute: false));
    }
        
    

    /**
     * Display the specified resource.
     */
    public function show(String $id)
    {
        if (!is_numeric($id)) {
            abort(404, 'Entrada inválida.');
            exit();
        }
        $user = auth()->user();
        if(1){
            $user =  auth()->user();
            $users = DB::table('users')
                ->join('entidades', 'users.entidade_id', '=', 'entidades.id')
                ->join('roles', 'users.role_id', '=', 'roles.id')
                ->join('estados', 'users.estado_id', '=', 'estados.id')
                ->select('users.*','users.email as userEmail', 'entidades.*', 'roles.*','estados.*')
                ->where("users.id",$id)
                ->get();
               //dd($users);
               return view('utilizador.show',compact('users'));
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }

        
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request){
        $dados = $request->all();
        $user = auth()->user();
        if($user->role_id==1){
            $Object = User::findORFail($dados['valor']);
            $Object->delete();
            return redirect()->back();
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
        
       
    }
}